/*
 * CarregaZones.java
 *
 * Created on 9 de junio de 2008, 17:22
 */

package servlets;

import entitats.Client;
import java.io.*;
import java.net.*;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import javax.naming.Context;
import javax.naming.InitialContext;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.sql.DataSource;
import locals.Local;
import locals.Zona;

/**
 *
 * @author dai
 * @version
 */
public class CarregaZones extends HttpServlet {
    
    Connection con = null;
    DataSource ds = null;
    ArrayList <Zona> zones = new ArrayList();
    ArrayList <Client> clients = new ArrayList();
    //Arraylist <Local> locals = new ArrayList();
    protected void processRequest(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        this.doGet(request, response);
    }
    
    // <editor-fold defaultstate="collapsed" desc="HttpServlet methods. Click on the + sign on the left to edit the code.">
    /** Handles the HTTP <code>GET</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        
        if ( request.getSession().getAttribute("zones") == null ) {
            zones.clear();
            try {
                Context contextoInicial = new InitialContext();
                Context contexto = (Context) contextoInicial.lookup("java:comp/env");
                
                if (request.getParameter("action") != null){
                    if (request.getParameter("action").equals("alta_local")) {
                        clients = (ArrayList) request.getAttribute("clients");
                        request.setAttribute("clients", clients);
                    }
                    /*if (request.getParameter("action").equals("modificacio_local")){
                        locals = (ArrayList) request.getAttribute("locals");
                        request.setAttribute("locals", locals);
                    }*/
                }
                
                ds = (DataSource) contexto.lookup( "jdbc/ConnexioImmobiliaria");
                con = ds.getConnection();
                Statement st = con.createStatement();
                ResultSet rs = st.executeQuery("SELECT * FROM zones");
                while ( rs.next() ) {
                    zones.add(new Zona(rs.getInt("id"), rs.getString("zona"), rs.getString("descripcio")));
                }
                HttpSession sessio = request.getSession();
                request.setAttribute("zones",zones);
                rs.close();
                st.close();
                con.close();
            } catch(Exception e) {
                System.out.println("ERROR: "+e.getMessage());
            } finally {
                try {
                    if (con != null ) {
                        con.close();
                    }
                } catch (Exception ex){}
            }
            
        }
        RequestDispatcher rD = null;
        if (request.getParameter("action").equals("alta_local"))
            rD = request.getRequestDispatcher("/alta_local.jsp");
        else if (request.getParameter("action").equals("alta_llogater"))
            rD = request.getRequestDispatcher("/alta_propietari.jsp");
        /*else if (request.getParameter("action").equals("modificacio_local"))
            rD = request.getRequestDispatcher()*/
            rD.forward(request, response);
        
        out.close();
    }
    
    /** Handles the HTTP <code>POST</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }
    
    /** Returns a short description of the servlet.
     */
    public String getServletInfo() {
        return "Short description";
    }
    // </editor-fold>
}
